# Paste Cells from Clipboard
# Copyright 2006 by Alexander V. Christensen
# Copyright 2007 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 070317 - first version based on Alexander's Paste Cells from Clipboard

def hint(s):
    try:
        Data.Hint("%s: %s" % (scriptname, s))
    except AttributeError:
        self.SetStatusText(s)

def SetCellValue(row, col, value):
    table = self.Report.table
    rowid = table.rows[row]
    of = table.coloffset[col]
    colid = table.columns[col]
    column = Data.SetCellValue(rowid, colid, of, value)

# the main function

def FillDown():

    # set local pointers to tables
    rid = self.ReportID  # current report
    drep = Data.Database['Report']
    drt = Data.Database['ReportType']
    rr = drep[rid]

    # make sure report has report type
    if not rr.has_key('ReportTypeID') or not drt.has_key(rr['ReportTypeID']): 
        if debug: print "ReportType key not found"
        hint("Error: Can't find type of this report.")
        return
    rtid = rr['ReportTypeID']

    # only allow fill down on one table reports
    rt = drt[rtid] # pointer to report type record
    ta = rt.get('TableA')
    tb = rt.get('TableB')  # if two table report all inserts go at the end (less confusing to user)
    if tb:
        hint('Only use with single table reports.')
        return
    
    if not isinstance(self.Report, wx.grid.Grid):
        hint("Run this script from a grid report.")
        return
    if not self.Report.GetNumberCols():
        hint("Insert columns first.")
        return

    cx = self.Report.table.columns
    ox = self.Report.table.coloffset
    rx = self.Report.table.rows
    if not (cx and rx):
        hint("There are no cells to copy yet.")
        return

    selcol = self.Report.GetSelectedCols()  # current selection

    seltl = self.Report.GetSelectionBlockTopLeft()  # current selection
    selbr = self.Report.GetSelectionBlockBottomRight()  # current selection

    if selcol: # columns selected
        r = range(len(rx))
        c = selcol
    elif seltl and selbr:
        r = range(seltl[0][0], selbr[0][0] + 1)
        c = range(seltl[0][1], selbr[0][1] + 1)
    else:
        hint("Must select a range of cells to fill down.")
        return

    def stringval(x):
        if isinstance(x, int) or isinstance(x, float):
            return str(x)
        elif isinstance(x, str):
            if x.count('\t'): x = x.replace('\t', r'\t')
            if x.count('\n'): x = x.replace('\n', r'\n')
            if x.count('\r'): x = x.replace('\r', r'\r')
            return x
        else:
            return x

    # is the lowest row the first one? -- I'm assuming it is
    r1 = r.pop(0)

    values = [ stringval(Data.GetCellValue(rx[r1], cx[ci], ox[ci])) for ci in c ]

    # paste the cells
    for i, ci in enumerate(c):
        for ri in r:
             # self.Report.SetCellValue(row, c, value)
             # print i, ci, ri, values[i]
             SetCellValue(ri, ci, values[i])

    Data.SetUndo("Fill Down")

FillDown()
